<?php

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);
ignore_user_abort(1);

// ##################### DEFINE IMPORTANT CONSTANTS #######################

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('maintenance');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_nominate_topic.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminthreads')){
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['maintenance']);

if (empty($_REQUEST['do'])){
	$_REQUEST['do'] = 'recounters';
}

$vbulletin->input->clean_array_gpc('r', array('perpage' => TYPE_UINT, 'startat' => TYPE_UINT));

($hook = vBulletinHook::fetch_hook('nominate_topic_admin_start')) ? eval($hook) : false;

if ($_REQUEST['do'] == 'recounters'){
	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_recounters_start')) ? eval($hook) : false;

	print_form_header('nominate_topic_admin', 'nominate_topic_user_amount');
	print_table_header($vbphrase['nominate_topic_user_amount'], 2, 0);
	print_description_row($vbphrase['nominate_topic_user_amount_help']);
	print_input_row($vbphrase['number_of_users_to_process_per_cycle'], 'perpage', 1000);
	print_submit_row($vbphrase['nominate_topic_user_amount']);

	print_form_header('nominate_topic_admin', 'nominate_topic_nominated_posts');
	print_table_header($vbphrase['nominate_topic_nominated_posts'], 2, 0);
	print_description_row($vbphrase['nominate_topic_nominated_posts_help']);
	print_input_row($vbphrase['number_of_users_to_process_per_cycle'], 'perpage', 1000);
	print_submit_row($vbphrase['nominate_topic_nominated_posts']);

	print_form_header('nominate_topic_admin', 'nominate_topic_nominated_times');
	print_table_header($vbphrase['nominate_topic_nominated_times'], 2, 0);
	print_description_row($vbphrase['nominate_topic_nominated_times_help']);
	print_input_row($vbphrase['number_of_users_to_process_per_cycle'], 'perpage', 1000);
	print_submit_row($vbphrase['nominate_topic_nominated_times']);
	
	print_form_header('nominate_topic_admin', 'nominate_topic_post_amount');
	print_table_header($vbphrase['nominate_topic_post_amount'], 2, 0);
	print_description_row($vbphrase['nominate_topic_post_amount_help']);
	print_input_row($vbphrase['number_of_posts_to_process_per_cycle'], 'perpage', 1000);
	print_submit_row($vbphrase['nominate_topic_post_amount']);

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_recounters_end')) ? eval($hook) : false;
}

if ($_REQUEST['do'] == 'nominate_topic_user_amount'){
	if (empty($vbulletin->GPC['perpage'])){
		$vbulletin->GPC['perpage'] = 1000;
	}

	$finishat = $vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'];

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_user_amount_start')) ? eval($hook) : false;

	echo '<p>' . $vbphrase['nominate_topic_user_amount'] . '</p>';

	$users = $db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "user WHERE userid >= " . $vbulletin->GPC['startat'] . " AND userid < $finishat ORDER BY userid");

	while ($user = $db->fetch_array($users)){
		$total = $db->query_first("SELECT COUNT(*) AS nominate_topic_user_amount FROM " . TABLE_PREFIX . "nominate_topic WHERE userid = $user[userid]");

		if (!($total[nominate_topic_user_amount])){
			$total[nominate_topic_user_amount] = 0;
		}

		$db->query_write("
            UPDATE " . TABLE_PREFIX . "user SET nominate_topic_user_amount = $total[nominate_topic_user_amount] WHERE userid = $user[userid]");

		echo construct_phrase($vbphrase['processing_x'], $user['userid']) . "<br />\n";
		vbflush();
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_user_amount_end')) ? eval($hook) : false;

	if ($checkmore = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid >= $finishat LIMIT 1")){
		print_cp_redirect("nominate_topic_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=nominate_topic_user_amount&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"nominate_topic_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=nominate_topic_user_amount&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else{
		define('CP_REDIRECT', 'nominate_topic_admin.php');
		print_stop_message('updated_post_counts_successfully');
	}
}

if ($_REQUEST['do'] == 'nominate_topic_nominated_posts')
{
	if (empty($vbulletin->GPC['perpage'])){
		$vbulletin->GPC['perpage'] = 1000;
	}

	$finishat = $vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'];

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_nominated_posts_start')) ? eval($hook) : false;

	echo '<p>' . $vbphrase['nominate_topic_nominated_posts'] . '</p>';

	$users = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid >= " . $vbulletin->GPC['startat'] . " AND userid < $finishat ORDER BY userid");

	while ($user = $db->fetch_array($users)){
		$total = $db->query_first("SELECT COUNT(*) AS nominate_topic_nominated_posts FROM " . TABLE_PREFIX . "post WHERE userid = $user[userid] AND nominate_topic_amount > 0");

		if (!($total[nominate_topic_nominated_posts])){
			$total[nominate_topic_nominated_posts] = 0;
		}

		$db->query_write("UPDATE " . TABLE_PREFIX . "user SET nominate_topic_nominated_posts = $total[nominate_topic_nominated_posts] WHERE userid = $user[userid]");

		echo construct_phrase($vbphrase['processing_x'], $user['userid']) . "<br />\n";
		vbflush();
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_nominated_posts_end')) ? eval($hook) : false;

	if ($checkmore = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid >= $finishat LIMIT 1")){
		print_cp_redirect("nominate_topic_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=nominate_topic_nominated_posts&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"nominate_topic_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=nominate_topic_nominated_posts&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else{
		define('CP_REDIRECT', 'nominate_topic_admin.php');
		print_stop_message('updated_post_counts_successfully');
	}
}

if ($_REQUEST['do'] == 'nominate_topic_nominated_times')
{
	if (empty($vbulletin->GPC['perpage'])){
		$vbulletin->GPC['perpage'] = 1000;
	}

	$finishat = $vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'];

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_nominated_times_start')) ? eval($hook) : false;

	echo '<p>' . $vbphrase['nominate_topic_nominated_times'] . '</p>';

	$users = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid >= " . $vbulletin->GPC['startat'] . " AND userid < $finishat ORDER BY userid");

	while ($user = $db->fetch_array($users)){
		$total = $db->query_first("SELECT SUM(nominate_topic_amount) AS nominate_topic_nominated_times FROM " . TABLE_PREFIX . "post WHERE userid = $user[userid] AND nominate_topic_amount > 0");

		if (!($total[nominate_topic_nominated_times])){
			$total[nominate_topic_nominated_times] = 0;
		}

		$db->query_write("UPDATE " . TABLE_PREFIX . "user SET nominate_topic_nominated_times = $total[nominate_topic_nominated_times] WHERE userid = $user[userid]");

		echo construct_phrase($vbphrase['processing_x'], $user['userid']) . "<br />\n";
		vbflush();
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_nominated_times_end')) ? eval($hook) : false;

	if ($checkmore = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid >= $finishat LIMIT 1")){
		print_cp_redirect("nominate_topic_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=nominate_topic_nominated_times&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"nominate_topic_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=nominate_topic_nominated_times&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else 	{
		define('CP_REDIRECT', 'nominate_topic_admin.php');
		print_stop_message('updated_post_counts_successfully');
	}
}

if ($_REQUEST['do'] == 'nominate_topic_post_amount'){
	if (empty($vbulletin->GPC['perpage'])){
		$vbulletin->GPC['perpage'] = 1000;
	}

	$finishat = $vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'];

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_post_amount_start')) ? eval($hook) : false;

	echo '<p>' . $vbphrase['nominate_topic_post_amount'] . '</p>';

	$posts = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "post WHERE postid >= " . $vbulletin->GPC['startat'] . " AND postid < $finishat ORDER BY postid");

	while ($post = $db->fetch_array($posts)){
		$total = $db->query_first("SELECT COUNT(*) AS nominate_topic_amount FROM " . TABLE_PREFIX . "nominate_topic WHERE postid = $post[postid]");

		if (!($total[nominate_topic_amount])){
			$total[nominate_topic_amount] = 0;
		}

		$db->query_write("UPDATE " . TABLE_PREFIX . "post SET nominate_topic_amount = $total[nominate_topic_amount] WHERE postid = $post[postid]");

		echo construct_phrase($vbphrase['processing_x'], $post['postid']) . "<br />\n";
		vbflush();
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_post_amount_end')) ? eval($hook) : false;

	if ($checkmore = $db->query_first("SELECT postid FROM " . TABLE_PREFIX . "post WHERE postid >= $finishat LIMIT 1")){
		print_cp_redirect("nominate_topic_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=nominate_topic_post_amount&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"nominate_topic_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=nominate_topic_post_amount&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else{
		define('CP_REDIRECT', 'nominate_topic_admin.php');
		print_stop_message('updated_post_counts_successfully');
	}
}

if ($_REQUEST['do'] == 'special_actions')
{
	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_special_actions_start')) ? eval($hook) : false;

	print_form_header('nominate_topic_admin', 'delete_all_users_nominations');
	print_table_header($vbphrase['nominate_topic_delete_all_users_nominations'], 2, 0);
	print_description_row($vbphrase['nominate_topic_delete_all_users_nominations_help']);
	print_input_row($vbphrase['userid'], 'userid');
	print_submit_row($vbphrase['nominate_topic_delete_all_users_nominations']);

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_special_actions_end')) ? eval($hook) : false;
}

if ($_REQUEST['do'] == 'delete_all_users_nominations')
{
	$vbulletin->input->clean_array_gpc('r', array('userid' => TYPE_UINT));

	$userid = $vbulletin->GPC['userid'];

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_delete_all_users_nominations_start')) ? eval($hook) : false;

//	echo '<p>' . $vbphrase['nominate_topic_delete_all_users_nominations'] . '</p>';

	$nominations = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic WHERE userid='$user_id' ORDER BY username");
	$nb=$vbulletin->db->num_rows($nominations);

	if ($nb != 0){
		while ($row = $vbulletin->db->fetch_array($nominations)){
			$post_id = $row['postid'];

			$get_post = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."post WHERE postid = '$post_id'");
			$nb_rows = $vbulletin->db->num_rows($get_post);
			if ($nb_rows != 0) {
				$postinfo = $vbulletin->db->fetch_array($get_post);
				delete_nomination($postinfo, '', $user_id);
			}

			echo construct_phrase($vbphrase['processing_x'], $post_id) . "<br />\n";
			vbflush();
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_delete_all_users_nominations_end')) ? eval($hook) : false;

	define('CP_REDIRECT', 'nominate_topic_admin.php?do=special_actions');
	print_stop_message('nominate_topic_delete_all_users_nominations_successfully');
}


if ($_REQUEST['do'] == 'refreshpollthread')
{
	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_refresh_poll_thread_start')) ? eval($hook) : false;

	echo '<p>' . $vbphrase['nominate_topic_refresh_poll_thread'] . '</p>';

	$now = time();
	$t = getdate($now);

	$day = date("j");
	$day_of_the_week = date("w");
	$days_in_month = date("t");
	$month = date("n");

	if ($vbulletin->options['nominate_topic_header_nextcyle'] == 1){
		if ($vbulletin->options['nominate_topic_week_month'] == 1){
			$nextWeek = $now + (7 * 24 * 60 * 60);
			$week_number = strftime("%V", $nextWeek);
			$month_name = strftime("%B", $nextWeek);
			$year_number = strftime("%Y", $nextWeek);
			$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_week'], $vbulletin->options['nominate_topic_contest_header'], $week_number, $month_name, $year_number);
			$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_week'], $vbulletin->options['nominate_topic_contest_header'], $week_number, $month_name, $year_number);
		}
		else {
			if ($vbulletin->options['nominate_topic_week_month'] == 2){
				if ($day < 15) {$fortnight = 2*$month;} else {$fortnight = 2*$month+1;}

				$twoWeeks = $now + (14 * 24 * 60 * 60);
				$week_number = strftime("%V", $twoWeeks);
				$month_name = strftime("%B", $twoWeeks);
				$year_number = strftime("%Y", $twoWeeks);
				$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_fortnight'], $vbulletin->options['nominate_topic_contest_header'], $fortnight, $week_number, $month_name, $year_number);
				$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_fortnight'], $vbulletin->options['nominate_topic_contest_header'], $fortnight, $week_number, $month_name, $year_number);
			}
			else {
				$next_month = mktime($t['hours'], $t['minutes'], $t['seconds'], $t['mon'] + 1, $t['mday'], $t['year']);
				$week_number = strftime("%V", $next_month);
				$month_name = strftime("%B", $next_month);
				$year_number = strftime("%Y", $next_month);
				$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_month'], $vbulletin->options['nominate_topic_contest_header'], $month_name, $year_number);
				$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_month'], $vbulletin->options['nominate_topic_contest_header'], $month_name, $year_number);
			}
		}
	}
	else {
		if ($vbulletin->options['nominate_topic_week_month'] == 1){

			$week_number = strftime("%V", $thisWeek);
			$month_name = strftime("%B", $now);
			$year_number = strftime("%Y", $now);
			$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_week'], $vbulletin->options['nominate_topic_contest_header'], $week_number, $month_name, $year_number);
			$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_week'], $vbulletin->options['nominate_topic_contest_header'], $week_number, $month_name, $year_number);
		}
		else {
			if ($vbulletin->options['nominate_topic_week_month'] == 2){
				if ($day < 15) {$fortnight = 2*$month - 1;} else {$fortnight = 2*$month;}

				$twoWeeks = $now + (14 * 24 * 60 * 60);
				$week_number = strftime("%V", $twoWeeks);
				$month_name = strftime("%B", $twoWeeks);
				$year_number = strftime("%Y", $twoWeeks);
				$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_fortnight'], $vbulletin->options['nominate_topic_contest_header'], $fortnight, $week_number, $month_name, $year_number);
				$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_fortnight'], $vbulletin->options['nominate_topic_contest_header'], $fortnight, $week_number, $month_name, $year_number);
			}
			else {
				$week_number = strftime("%V", $now);
				$month_name = strftime("%B", $now);
				$year_number = strftime("%Y", $now);
				$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_month'], $vbulletin->options['nominate_topic_contest_header'], $month_name, $year_number);
				$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_month'], $vbulletin->options['nominate_topic_contest_header'], $month_name, $year_number);
			}
		}
	}

	$nominatetopicthread = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic_thread WHERE postid > '0'");
	$nb_rows = $vbulletin->db->num_rows($nominatetopicthread);
	$row = $vbulletin->db->fetch_array($nominatetopicthread);
	$nominationthread_pollid = $row['pollid'];
	$nominationthread_threadid = $row['threadid'];
	$nominationthread_postid = $row['postid'];

	if ($nb_rows != 0){
		// Update the poll on the receiving thread by displaying resulting votes.

		$get_most_nominated = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."post WHERE nominate_topic_amount > 0 AND visible = '1' AND nominate_topic_award = '0' ORDER BY nominate_topic_amount DESC");
		$nb_most_nominated = $vbulletin->db->num_rows($get_most_nominated);
		$get_most_nominated = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."post WHERE nominate_topic_amount > 0 AND visible = '1' AND nominate_topic_award = '0' ORDER BY nominate_topic_amount DESC");
		$nb_most_nominated = $vbulletin->db->num_rows($get_most_nominated);

		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$get_most_nominated_blog = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."blog WHERE nominate_topic_amount > 0 AND state = 'visible' AND nominate_topic_award = '0' ORDER BY nominate_topic_amount DESC");
			$nb_most_nominated_blog = $vbulletin->db->num_rows($get_most_nominated_blog);
		}

		$nominatedposttitle[0] = $vbphrase['nominate_topic_awaiting_nominees'];
		$nominatedposttitle[$max_Poll_choices] = $vbphrase['nominate_topic_remaining_nominations'];
		$max_Poll_choices = $vbulletin->options['nominate_topic_max_per_poll'];
		$totalNominationsCount = 0;
		$nominatedcount[0] = $nominatedcount[1] = $nominatedcount[2] = $nominatedcount[3] = $nominatedcount[4] = $nominatedcount[5] = $nominatedcount[6] = $nominatedcount[7] = $nominatedcount[8] = $nominatedcount[9] = 0;
		$site_URL = $vbulletin->options[bburl];

		if (($nb_most_nominated != 0) || ($nb_most_nominated_blog != 0)){

			$i = -1;

			if ($nb_most_nominated != 0) {
				$max_Poll_choices = $vbulletin->options['nominate_topic_max_per_poll'];
				while ($row = $vbulletin->db->fetch_array($get_most_nominated)){
					if ( $i < $max_Poll_choices - 1){
						$i++;

						$nominatedpost_threadid[$i] = $row['threadid'];
						$post_id = $row['postid'];
						$post_threadid = $row['threadid'];
						$nominatedpostid[$i] = $post_id;
						$nominatedpost_isblog[$i] = 0;

						$post_title = $row['title'];
						if (empty($post_title)) {
							$threadinfo = fetch_threadinfo($post_threadid); 
							$post_title = $threadinfo['title'];
						}

						$nominatedposttitle[$i] = "[post=".$post_id."]".$post_title."[/post]";
						$nominatedcount[$i] = $row['nominate_topic_amount'];
					}
					else{
						$i = $max_Poll_choices;
						$nominatedcount[$i] = $nominatedcount[$i] + $row['nominate_topic_amount'];
						if ($postinfo['postid'] == $row['postid']){
							$nominatedpostid[$i] = $row['postid'];
						}
					}

					$totalNominationsCount = $totalNominationsCount + $row['nominate_topic_amount'];
				}
			}

			if (($nb_most_nominated_blog != 0) AND ($vbulletin->options['nominate_topic_blog_on_off'])){
				while ($row = $vbulletin->db->fetch_array($get_most_nominated_blog)){

					$blog_id = $row['blogid'];
					$blog_title = $row['title'];
					$nt_amount = $row['nominate_topic_amount'];

					$j = 0;
					while (($nt_amount < $nominatedcount[$j]) AND ($j <= i)){$j++;}

					if ($j < $i+1) {
						for ($k = $i+1; $k > $j; $k--) {
							$nominatedpost_threadid[$k] = $nominatedpost_threadid[$k-1];
							$nominatedpostid[$k] = $nominatedpostid[$k-1];
							$nominatedpost_isblog[$k] = $nominatedpost_isblog[$k-1];
							$nominatedposttitle[$k] = $nominatedposttitle[$k-1];
							$nominatedcount[$k] = $nominatedcount[$k-1];
						}
					}

					$nominatedpost_threadid[$j] = $blog_id;
					$nominatedpostid[$j] = $blog_id;
					$nominatedpost_isblog[$j] = 1;
					$nominatedposttitle[$j] = "[url=".$site_URL."/blog.php?$session[sessionurl]b=".$blog_id."]Blog: ".$blog_title."[/url]";
					$nominatedcount[$j] = $nt_amount;

					if ( $i < $max_Poll_choices - 1){
						$i++;
					}
					else{
						$i = $max_Poll_choices;
						$nominatedcount[$i] = $nominatedcount[$i] + $row['nominate_topic_amount'];
						if ($bloginfo['blogid'] == $row['blogid']){
							$nominatedpostid[$i] = $row['blogid'];
						}
					}

					$totalNominationsCount = $totalNominationsCount + $row['nominate_topic_amount'];
				}
			}

			for ($j = 0; $j < $max_Poll_choices; $j++) {
				$nominatedposttitle[$j] = str_replace("'", "\'", $nominatedposttitle[$j]);
			}

			$voters = $totalNominationsCount;
			$numberoptions = $i+1;

			switch ($i) {
				case 0:
					$votes = $nominatedcount[0];
					$choices = $nominatedposttitle[0];
					break;
				case 1:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1];
					break;
				case 2:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2];
					break;
				case 3:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3];
					break;
				case 4:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4];
					break;
				case 5:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5];
					break;
				case 6:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6];
					break;
				case 7:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7];
					break;
				case 8:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7]."|||".$nominatedcount[8];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7]."|||".$nominatedposttitle[8];
					break;
				case 9:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7]."|||".$nominatedcount[8]."|||".$nominatedcount[9];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7]."|||".$nominatedposttitle[8]."|||".$nominatedposttitle[9];
					break;
			}

			$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "poll` SET `question` = '$question', `options`='$choices', `votes`='$votes', `numberoptions`='$numberoptions' , `voters`='$voters', `lastvote`='$lastvote' WHERE `pollid` = '$nominationthread_pollid'");

			// Update the pollvote table by removing trailing users whose posts might have been deleted for some reasons.

			$get_pollvote = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."pollvote WHERE pollid = '$nominationthread_pollid'");
			$nb_pollvote = $vbulletin->db->num_rows($get_pollvote);
			if ($nb_pollvote != 0){
				while ($row = $vbulletin->db->fetch_array($get_pollvote)){
					$k = 0;
					$found_user = ($row['userid'] == $array_userid[$k]);
					while ((!($found_user)) && ($k < $nb_userid)) {
						$k++;
						$found_user = ($row['userid'] == $array_userid[$k]);
					}
					if (!($found_user)) {
						$this_userid = $row['userid'];
						$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."pollvote WHERE pollid = '$nominationthread_pollid' AND userid = '$this_userid'");
					}
				}
			}

			for ($k = 0; $k < $nb_userid; $k++) {
				$user_id = $array_userid[$k];
				$get_user_nominations = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic WHERE userid = '$user_id'");
				while ($user_nominee = $vbulletin->db->fetch_array($get_user_nominations)){
					$post_id = $user_nominee['postid'];

					for ($j = 0; $j < $numberoptions; $j++) {
						if ($postinfo['postid'] == $post_id){
							$vote_option = $j+1;
						}
					}
					//$vote_option = array_search($post_id, $arrayPostID);
					if ($vote_option > 0){
						$get_pollvote = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."pollvote WHERE userid = '$user_id' AND pollid = '$poll_id' AND voteoption = '$vote_option' AND votetype ='$vote_option'");
						$nb_pollvote = $vbulletin->db->num_rows($get_pollvote);
						if ($nb_pollvote == 0){
							$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "pollvote (pollid,userid,votedate,voteoption,votetype) VALUES ('$poll_id','$user_id','$now','$vote_option','$vote_option')");
						}
					}
				}
			}
		}
		else {
			$choices = $nominatedposttitle[0];
			$votes = $nominatedcount[0];
			$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "poll` SET `options`='$choices', `votes`='$votes', `numberoptions`='0' , `voters`='0', `lastvote`='$lastvote' WHERE `pollid` = '$nominationthread_pollid'");
		}

	// Update the title of the receiving thread in case it was changed.

	$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "thread` SET `title`='$newThreadTitle' WHERE `threadid` = '$nominationthread_threadid'");
	$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "post` SET `title`='$newThreadTitle' WHERE `postid` = '$nominationthread_postid'");
	$vbulletin->db->query_write("DELETE FROM `". TABLE_PREFIX ."postparsed` WHERE `postid` = '$nominationthread_postid'");
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_refresh_poll_thread_end')) ? eval($hook) : false;

	print_stop_message('nominate_topic_refreshpollthread_successfully');
}

if ($_REQUEST['do'] == 'createnewpollthread')
{
	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_create_new_poll_thread_start')) ? eval($hook) : false;

	echo '<p>' . $vbphrase['nominate_topic_create_new_poll_thread'] . '</p>';

	if (!($vbulletin->options['nominate_topic_receiving_forumid'])){
		echo "$forumid_not_specified<br>";
		exit;
	}

	$now = time();
	$t = getdate($now);

	$day = date("j");
	$day_of_the_week = date("w");
	$days_in_month = date("t");
	$month = date("n");

	if ($vbulletin->options['nominate_topic_header_nextcyle'] == 1){
		if ($vbulletin->options['nominate_topic_week_month'] == 1){
			$nextWeek = $now + (7 * 24 * 60 * 60);
			$week_number = strftime("%V", $nextWeek);
			$month_name = strftime("%B", $nextWeek);
			$year_number = strftime("%Y", $nextWeek);
			$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_week'], $vbulletin->options['nominate_topic_contest_header'], $week_number, $month_name, $year_number);
			$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_week'], $vbulletin->options['nominate_topic_contest_header'], $week_number, $month_name, $year_number);
		}
		else {
			if ($vbulletin->options['nominate_topic_week_month'] == 2){
				if ($day < 15) {$fortnight = 2*$month;} else {$fortnight = 2*$month+1;}

				$twoWeeks = $now + (14 * 24 * 60 * 60);
				$week_number = strftime("%V", $twoWeeks);
				$month_name = strftime("%B", $twoWeeks);
				$year_number = strftime("%Y", $twoWeeks);
				$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_fortnight'], $vbulletin->options['nominate_topic_contest_header'], $fortnight, $week_number, $month_name, $year_number);
				$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_fortnight'], $vbulletin->options['nominate_topic_contest_header'], $fortnight, $week_number, $month_name, $year_number);
			}
			else {
				$next_month = mktime($t['hours'], $t['minutes'], $t['seconds'], $t['mon'] + 1, $t['mday'], $t['year']);
				$week_number = strftime("%V", $next_month);
				$month_name = strftime("%B", $next_month);
				$year_number = strftime("%Y", $next_month);
				$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_month'], $vbulletin->options['nominate_topic_contest_header'], $month_name, $year_number);
				$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_month'], $vbulletin->options['nominate_topic_contest_header'], $month_name, $year_number);
			}
		}
	}
	else {
		if ($vbulletin->options['nominate_topic_week_month'] == 1){

			$week_number = strftime("%V", $thisWeek);
			$month_name = strftime("%B", $now);
			$year_number = strftime("%Y", $now);
			$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_week'], $vbulletin->options['nominate_topic_contest_header'], $week_number, $month_name, $year_number);
			$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_week'], $vbulletin->options['nominate_topic_contest_header'], $week_number, $month_name, $year_number);
		}
		else {
			if ($vbulletin->options['nominate_topic_week_month'] == 2){
				if ($day < 15) {$fortnight = 2*$month - 1;} else {$fortnight = 2*$month;}

				$twoWeeks = $now + (14 * 24 * 60 * 60);
				$week_number = strftime("%V", $twoWeeks);
				$month_name = strftime("%B", $twoWeeks);
				$year_number = strftime("%Y", $twoWeeks);
				$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_fortnight'], $vbulletin->options['nominate_topic_contest_header'], $fortnight, $week_number, $month_name, $year_number);
				$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_fortnight'], $vbulletin->options['nominate_topic_contest_header'], $fortnight, $week_number, $month_name, $year_number);
			}
			else {
				$week_number = strftime("%V", $now);
				$month_name = strftime("%B", $now);
				$year_number = strftime("%Y", $now);
				$question = construct_phrase($vbphrase['nominate_topic_which_post_shouldwin_month'], $vbulletin->options['nominate_topic_contest_header'], $month_name, $year_number);
				$newThreadTitle = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_month'], $vbulletin->options['nominate_topic_contest_header'], $month_name, $year_number);
			}
		}
	}

	$nominatetopicthread = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic_thread WHERE postid > '0'");
	$nb_rows = $vbulletin->db->num_rows($nominatetopicthread);
	$row = $vbulletin->db->fetch_array($nominatetopicthread);
	$nominationthread_pollid = $row['pollid'];
	$nominationthread_threadid = $row['threadid'];
	$nominationthread_postid = $row['postid'];
	$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."nominate_topic_thread WHERE '1'");

	if ($nbrows > 0){
		// Clear all previous nominations
		$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."nominate_topic WHERE '1'");

		// Reset non awarded posts
		$get_non_awards = $vbulletin->db->query_read("SELECT postid, nominate_topic_amount FROM ". TABLE_PREFIX ."post WHERE visible = '1' AND nominate_topic_award = '0'");
		$nb_non_awards = $vbulletin->db->num_rows($get_non_awards);

		if ($nb_non_awards != 0){
			while ($row = $vbulletin->db->fetch_array($get_non_awards)){
				$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "post` SET `nominate_topic_amount` = '0' WHERE postid = '$row[postid]'");
			}
		}

		// Reset non awarded blogs entries
		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$get_non_awards = $vbulletin->db->query_read("SELECT blogid, nominate_topic_amount FROM ". TABLE_PREFIX ."blog WHERE state = 'visible' AND nominate_topic_award = '0'");
			$nb_non_awards = $vbulletin->db->num_rows($get_non_awards);

			if ($nb_non_awards != 0){
				while ($row = $vbulletin->db->fetch_array($get_non_awards)){
					$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "blog` SET `nominate_topic_amount` = '0' WHERE blogid = '$row[blogid]'");
				}
			}
		}
	}

	// Close the current nomination thread if exist

	$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "thread` SET `open`='0' WHERE `threadid` = '$nominationthread_threadid'");

	// Create new poll and thread

	$Choice = $vbphrase['nominate_topic_awaiting_nominees'];

	$votes = "0";
	$active = 0;
	$numberoptions = 1;
	$timeout = 7;
	$multiple = 1;
	$voters = 0;
	$public = 0;
	$lastvote = 0;

	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "poll (question,dateline,options,votes,active,numberoptions,timeout,multiple,voters,public,lastvote) VALUES ('$question','$now','$Choice','$votes','$active','$numberoptions','$timeout','$multiple','$voters','$public','$lastvote')");
	$thisPoll = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."poll WHERE `question` = '$question' AND `dateline`='$now' ORDER BY pollid DESC");
	$nb = $vbulletin->db->num_rows($thisPoll);

	$curPoll = $vbulletin->db->fetch_array($thisPoll);
	$newpoll_id = $curPoll['pollid'];
	$nt_thread_message = $vbulletin->options['nominate_topic_thread_message'];
	$receiving_forum_id = $vbulletin->options['nominate_topic_receiving_forumid'];

	$threadOwnerID = $vbulletin->options['nominate_topic_thread_owner_id'];
	$userslist = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."user WHERE userid = '$threadOwnerID'");
	$nb = $vbulletin->db->num_rows($userslist);
	if ($nb == 0){$threadOwnerID = 1;}

	$get_forum = $vbulletin->db->query_read("SELECT * FROM `". TABLE_PREFIX ."forum` WHERE `forumid` = '$receiving_forum_id'");
	$foruminfo = $vbulletin->db->fetch_array($get_forum);

	$foruminfo = fetch_foruminfo($receiving_forum_id);

	$threaddm =& datamanager_init('Thread_FirstPost', $vbulletin, ERRTYPE_ARRAY, 'threadpost');

	$threaddm->set_info('forum', $foruminfo);
	$threaddm->set('forumid', $receiving_forum_id);
	$threaddm->set('userid', $threadOwnerID);
	$threaddm->set('title', $newThreadTitle);
	$threaddm->set('pagetext', $nt_thread_message);
	$threaddm->set('allowsmilie', 1);
	$threaddm->set('visible', 1);
	$threaddm->set('dateline', $now);
	$threaddm->set('pollid', $newpoll_id);
	$thread_id = $threaddm->save();

	$get_thisthread = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."thread WHERE threadid = '$thread_id' ORDER BY threadid DESC");
	$thisthread = $vbulletin->db->fetch_array($get_thisthread);
	$firstpost_id = $thisthread['firstpostid'];
	$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."postparsed WHERE `postid` = '$firstpost_id'");

	$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."nominate_topic_thread WHERE '1'");
	$vbulletin->db->query_write("INSERT INTO ". TABLE_PREFIX ."nominate_topic_thread (postid, threadid, pollid) VALUES ('" . $firstpost_id . "', '" . $thread_id . "', '" . $newpoll_id . "') ");

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_create_new_poll_thread_end')) ? eval($hook) : false;

	print_stop_message('nominate_topic_createnewpollthread_successfully');
}


if ($_REQUEST['do'] == 'updatenominatedpostsicons')
{
	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_update_nominated_posts_icons_start')) ? eval($hook) : false;

	echo '<p>' . $vbphrase['nominate_topic_update_nominated_posts_icons'] . '</p>';

	// Non-award winners posts
	$get_non_awards = $vbulletin->db->query_read("SELECT postid, threadid FROM ". TABLE_PREFIX ."post WHERE visible = '1' AND nominate_topic_amount > 0 AND nominate_topic_award = '0'");
	$nb_non_awards = $vbulletin->db->num_rows($get_non_awards);
	$icon_id = $vbulletin->options['nominate_topic_iconnominated'];

	if ($nb_non_awards != 0){
		while ($row = $vbulletin->db->fetch_array($get_non_awards)){
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET iconid = '$icon_id' WHERE postid = '$row[postid]'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "thread SET iconid = '$icon_id' WHERE threadid = '$row[threadid]'");
		}
	}

	// Award winners posts
	$get_awards = $vbulletin->db->query_read("SELECT postid, threadid FROM ". TABLE_PREFIX ."post WHERE visible = '1' AND nominate_topic_amount > 0 AND nominate_topic_award > 0");
	$nb_awards = $vbulletin->db->num_rows($get_awards);
	$icon_id = $vbulletin->options['nominate_topic_iconawardwinner'];

	if ($nb_awards != 0){
		while ($row = $vbulletin->db->fetch_array($get_awards)){
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET iconid = '$icon_id' WHERE postid = '$row[postid]'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "thread SET iconid = '$icon_id' WHERE threadid = '$row[threadid]'");
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_admin_update_nominated_posts_icons_end')) ? eval($hook) : false;

	print_stop_message('nominate_topic_updatenominatedpostsicons_successfully');
}

($hook = vBulletinHook::fetch_hook('nominate_topic_admin_end')) ? eval($hook) : false;

print_cp_footer();
?>
